/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class BlockGroup {
    protected BlockGroup fParentGroup;
    protected String fIconName;
    protected Icon fIcon;
    protected Boolean fBlockGroupVisible = Boolean.TRUE;
    protected String fName;
    protected List fBlocks = new ArrayList();
    protected String fBlockNamePrefix;
    protected Boolean fBlocksAreRightTerminals;

    public BlockGroup(String name) {
        this.fName = name;
        this.fIconName = name + "Icon.gif";
    }

    public BlockGroup(String name, String iconName) {
        this.fName = name;
        this.fIconName = iconName;
    }

    public void addElement(Object element) {
        List blocks = this.getBlocks();
        if (!blocks.contains(element)) {
            blocks.add(element);
            if (element instanceof BlockGroup) {
                ((BlockGroup)element).setParentGroup(this);
            }
        }
    }

    public void removeBlock(Object element) {
        if (this.getBlocks().remove(element) && element instanceof BlockGroup) {
            ((BlockGroup)element).setParentGroup(null);
        }
    }

    public Icon getIcon() {
        if (this.fIcon == null) {
            this.fIcon = Global.getIcon(this.fIconName);
        }
        return this.fIcon;
    }

    public String getName() {
        return this.fName;
    }

    public List getBlocks() {
        if (this.fBlocks == null) {
            this.fBlocks = new ArrayList(7);
        }
        return this.fBlocks;
    }

    public Boolean getBlocksAreRightTerminals() {
        if (this.fBlocksAreRightTerminals == null && this.getParentGroup() != null) {
            return this.getParentGroup().getBlocksAreRightTerminals();
        }
        return this.fBlocksAreRightTerminals;
    }

    public void setBlocksAreRightTerminals(Boolean blocksAreRightTerminals) {
        this.fBlocksAreRightTerminals = blocksAreRightTerminals;
    }

    public String getBlockNamePrefix() {
        if (this.fBlockNamePrefix == null && this.getParentGroup() != null) {
            return this.getParentGroup().getBlockNamePrefix();
        }
        return this.fBlockNamePrefix;
    }

    public void setBlockNamePrefix(String blockNamePrefix) {
        this.fBlockNamePrefix = blockNamePrefix;
    }

    public BlockGroup getParentGroup() {
        return this.fParentGroup;
    }

    public void setParentGroup(BlockGroup parentGroup) {
        this.fParentGroup = parentGroup;
    }

    public String getLocalizedName() {
        return Language.getString("blockGroup." + this.fName, this.fName);
    }

    public Boolean getBlockGroupVisible() {
        return this.fBlockGroupVisible;
    }

    public void setBlockGroupVisible(Boolean blockGroupVisible) {
        this.fBlockGroupVisible = blockGroupVisible;
    }

    public Object getElementAt(int index) {
        return this.fBlocks.get(index);
    }

    public int getElementCount() {
        return this.fBlocks.size();
    }

    public String toString() {
        return "BlockGroup: name=" + this.fName + "; elements=" + this.fBlocks;
    }
}

